/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.RandomXS128;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import technology.rocketjump.undermount.entities.EntityStore;
import technology.rocketjump.undermount.entities.planning.BackgroundTaskManager;
import technology.rocketjump.undermount.environment.GameClock;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextFactory;
import technology.rocketjump.undermount.gamecontext.GameContextRegister;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.mapping.factories.TiledMapFactory;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.screens.GameScreen;
import technology.rocketjump.undermount.screens.IntroScreen;
import technology.rocketjump.undermount.screens.MainGameScreen;
import technology.rocketjump.undermount.screens.MainMenuScreen;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.GameInteractionStateContainer;
import technology.rocketjump.undermount.ui.views.GuiViewName;

@Singleton
public class ScreenManager
implements Telegraph {
    private final MessageDispatcher messageDispatcher;
    private final TiledMapFactory mapFactory;
    private final ProfessionDictionary professionDictionary;
    private final BackgroundTaskManager backgroundTaskManager;
    private Injector injector;
    private final GameContextRegister gameContextRegister;
    private final GameInteractionStateContainer gameInteractionStateContainer;
    private Screen currentScreen;
    private MainGameScreen mainGameScreen;
    private MainMenuScreen mainMenuScreen;
    private IntroScreen introScreen;

    @Inject
    public ScreenManager(MessageDispatcher messageDispatcher, TiledMapFactory mapFactory, ProfessionDictionary professionDictionary, BackgroundTaskManager backgroundTaskManager, GameContextRegister gameContextRegister, MainGameScreen mainGameScreen, MainMenuScreen mainMenuScreen, IntroScreen introScreen, GameInteractionStateContainer gameInteractionStateContainer) {
        this.messageDispatcher = messageDispatcher;
        this.mapFactory = mapFactory;
        this.professionDictionary = professionDictionary;
        this.backgroundTaskManager = backgroundTaskManager;
        this.gameContextRegister = gameContextRegister;
        this.mainGameScreen = mainGameScreen;
        this.mainMenuScreen = mainMenuScreen;
        this.introScreen = introScreen;
        this.gameInteractionStateContainer = gameInteractionStateContainer;
        messageDispatcher.addListener(this, 1);
        messageDispatcher.addListener(this, 2);
    }

    public void init(Injector injector) {
        this.injector = injector;
    }

    private void startNewGame() {
        this.clearState();
        long worldSeed = this.newGameSeed();
        EntityStore newEntityStore = this.injector.getInstance(EntityStore.class);
        TiledMap areaMap = this.mapFactory.create(worldSeed, 320, 240, newEntityStore);
        GameClock gameClock = new GameClock(this.messageDispatcher);
        GameContext gameContext = new GameContextFactory().create(areaMap, newEntityStore, worldSeed, gameClock);
        this.gameContextRegister.setNewContext(gameContext);
        this.mapFactory.postInitStep(gameContext, this.messageDispatcher, this.buildProfessionList());
        this.gameInteractionStateContainer.clearState();
        this.mainGameScreen.show();
    }

    private List<Profession> buildProfessionList() {
        ArrayList<Profession> professionList = new ArrayList<Profession>();
        this.add(professionList, "MINER", 3);
        this.add(professionList, "LUMBERJACK", 3);
        this.add(professionList, "CARPENTER", 3);
        this.add(professionList, "STONEMASON", 3);
        this.add(professionList, "BLACKSMITH", 1);
        this.add(professionList, "FARMER", 1);
        this.add(professionList, "FISHER", 1);
        this.add(professionList, "HUNTER", 1);
        this.add(professionList, "VILLAGER", 2);
        return professionList;
    }

    private void add(List<Profession> professionList, String professionName, int quantity) {
        for (int cursor = 0; cursor < quantity; ++cursor) {
            Profession profession = this.professionDictionary.getByName(professionName);
            if (profession == null) {
                System.err.println("Could not find profession by name: " + professionName);
                continue;
            }
            professionList.add(profession);
        }
    }

    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        this.messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.DEFAULT);
        this.messageDispatcher.dispatchMessage(251, (Object)GuiViewName.DEFAULT_MENU);
        switch (msg.message) {
            case 1: {
                if (this.currentScreen != null) {
                    this.currentScreen.hide();
                }
                this.startNewGame();
                this.currentScreen = this.mainGameScreen;
                return true;
            }
            case 2: {
                GameScreen targetScreenType = (GameScreen)((Object)msg.extraInfo);
                if (this.currentScreen != null) {
                    this.currentScreen.hide();
                }
                switch (targetScreenType) {
                    case MAIN_MENU: {
                        this.mainMenuScreen.show();
                        this.currentScreen = this.mainMenuScreen;
                        break;
                    }
                    case MAIN_GAME: {
                        this.mainGameScreen.show();
                        this.currentScreen = this.mainGameScreen;
                        break;
                    }
                    case INTRO: {
                        this.introScreen.show();
                        this.currentScreen = this.introScreen;
                        break;
                    }
                    default: {
                        throw new NotImplementedException("not yet implemented:" + targetScreenType.name());
                    }
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    public void clearState() {
        this.backgroundTaskManager.reset();
        this.messageDispatcher.clearQueue();
    }

    private long newGameSeed() {
        try {
            File file = Gdx.files.internal("seed.txt").file();
            FileReader reader = new FileReader(file);
            List<String> lines = IOUtils.readLines(reader);
            long seed = Long.valueOf(lines.get(0));
            ((Reader)reader).close();
            if (seed == 0L) {
                return new RandomXS128().nextLong();
            }
            return seed;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onResize(int width, int height) {
        if (this.currentScreen != null) {
            this.currentScreen.resize(width, height);
        }
    }
}

